package org.jcon.df.edit.task;

// import org.jcon.util.GenLib;
import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;

/**
 * Represents a Param driven task type. Most of the task's
 * logic is expressed in its Param.
 *
 * @author Jack Harich
 */
public interface Task {

/**
 * Returns the "TaskType" identifier, such as "EditFields".
 * This is unique per implementer.
 */
public String getType();

/**
 * Sets the TaskContext property, for use in collaborating
 * with the task's environment.
 */
public void setTaskContext(TaskContext taskContext);

/**
 * Sets the task's metaParam. This is an abbreviated Param
 * that can be expanced using a schema, metaParam
 * properties and such.
 */
public void setMetaParam(Param metaParam);

/**
 * The task should build the Param to be used from the
 * metaParam. This is by expanding it into the complete
 * Param, or if it is already complete, just returning the
 * metaParam.
 */
public Param buildUseParam();

/**
 * This allows the task to observe the EditEvent stream.
 * The task may take appropriate action or do nothing.
 * Return true to consume the event or false to let it
 * proceed.
 * <p>
 * In most cases we expect no action to be taken and false
 * returned, since most of the task's behavior is defined
 * by its Param.
 */
public boolean handleEditEvent(EditEvent evt);


} // End interface

//========== Skeleton ====================================
/**
import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;

//---------- Task Implementation -------------------------
public String getType() {
    return "XXX";
}
public void setTaskContext(TaskContext taskContext) {
    this.taskContext = taskContext;
}
public void setMetaParam(Param metaParam) {
    this.metaParam = metaParam;
}
public Param buildUseParam() {
    // *** do
}
public boolean handleEditEvent(EditEvent evt) {
    // *** do
    return false; // Not consumed

}
*/
