package org.jcon.df.edit.task;

// import org.jcon.util.GenLib;
import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;

/**
 * This task allows the user to edit fields in a single
 * window. It arranges a RowFieldPanel, MoveButtonBar and
 * EditButtonBar in the window.
 *
 * @author Jack Harich
 */
public class EditFieldsTask implements Task {

//---------- Private Fields ------------------------------
private TaskContext taskContext;
private Param       metaParam;

//---------- Task Implementation -------------------------
public String getType() {
    return "EditFields";
}
public void setTaskContext(TaskContext taskContext) {
    this.taskContext = taskContext;
}
public void setMetaParam(Param metaParam) {
    this.metaParam = metaParam;
}
public Param buildUseParam() {
    String paramType = metaParam.getString("ParamType");
    if (paramType.startsWith("Config")) {
        String dbName = metaParam.getString("DataRequest.Database");
        Expander expander = new Expander();
        expander.setSchema(taskContext.getSchema());
        return expander.expandParam(metaParam);
    } else {
        return metaParam;
    }
}
public boolean handleEditEvent(EditEvent evt) {
    // No events are of interest
    return false; // Not consumed
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("EditFieldsTask" + text);
}

} // End class
