package org.jcon.df.edit.task;

import org.jcon.util.GenLib;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditEvent;
import org.jcon.param.Param;

/**
 * This task allows the user to browse a list of rows in
 * in one window, and edit fields in a another window.
 *
 * @author Jack Harich
 */
public class BrowseEditFieldsTask implements Task {

//---------- Private Fields ------------------------------
private TaskContext taskContext;
private Param       metaParam;

//---------- Task Implementation -------------------------
public String getType() {
    return "BrowseEditFields";
}
public void setTaskContext(TaskContext taskContext) {
    this.taskContext = taskContext;
}
public void setMetaParam(Param metaParam) {
    this.metaParam = metaParam;
}
public Param buildUseParam() {
    String paramType = metaParam.getString("ParamType");
    if (paramType.startsWith("Config")) {
        String dbName = metaParam.getString("DataRequest.Database");
        Expander expander = new Expander();
        expander.setSchema(taskContext.getSchema());
        return expander.expandParam(metaParam);
    } else {
        return metaParam;
    }
}
public boolean handleEditEvent(EditEvent evt) {
    switch(evt.getEventType()) {
        case EditEvent.BEGIN_ADD:
            return ensureDetailIsVisible();
        case EditEvent.BEGIN_CHANGE:
            return ensureDetailIsVisible();
    }
    return false; // Not consumed
}
//---------- Private Methods -----------------------------
private boolean ensureDetailIsVisible() {
    DataView view = taskContext.getView("DetailView");
    if (view == null) {
        IllegalStateException ex = new IllegalStateException(
            "View named 'DetailView' not found.");
        GenLib.exception("BrowseEditFielddsTask.ensureDetailIsVisible()",
            "Cannot find detail view.", ex);
        return true;
    } else {
        if (! view.isVisible()) {
            view.setVisible(true);
        } else {
            //print(".ensureDetailIsVisible() already visible");
        }
        return false;
    }
}
//--- Std
private static void print(String text) {
    System.out.println("BrowseEditFieldsTask" + text);
}

} // End class
