package org.jcon.df.edit.structure;

/**
* The interface for structure suppliers, such as an
* ItemListSupplier. 
*
* @author Jack Harich
*/
public interface StructureSupplier {

public static final int NORMAL_MODE = 1;
public static final int LOCAL_MODE  = 2;

/**
* Returns the unique name of the supplier.
*/
public String getStructureSupplierName();

/**
* The implementer should supply the drillObject by getting
* the appropriate instance and type, given the item, and
* calling Item.setDrillObject(Object drillObject).
* <p>
* This allows delayed instantiation of the drillObject, 
* which greatly speeds loading large structures. The user
* sees only the icon and value, which serve as a sort of
* proxy for the drillObject.
* <p>
* We have the implementer set the drillObject rather than
* the item user, so that we have uniform behavior and the
* item's behavior is more encapsulated.
*/
public void supplyDrillObject(Item item);

/**
* Returns true if the behavior is supported by this item,
* false if not. This is designed to support dynamic context
* menus and buttons, but may also be used for behavior choices
* hidden from the user such as moving or copying items.
* Usually behavior is a String mapped to an Action.
*/
public boolean isBehaviorSupported(Object behavior, Item item);

/**
* Sets the mode to run in. The default should be NORMAL_MODE.
* The purpose of modes is to allow easy testing, running
* locally, etc.
*/
public void setMode(int mode);

/**
* Returns the current mode.
*/
public int getMode();



} // End interface 
