package org.jcon.df.edit.structure;

//import org.jcon.util.TNode;

/**
* The interface for suppliers of item tree data structures,
* which are a hierarchy of Items.
*
* @author Jack Harich
*/
public interface ItemTreeSupplier extends StructureSupplier {

/**
* Returns the root for this supplier, which contains all
* the items for this supplier that are initially available.
* The TNodes userObjects must be an Item.
*/
//public ItemNode getRootNodeItem();
public Item getRootItem();

/**
* Returns a new Item initialized to default state. This
* allows the user to add an Item. Later addItem(...) will
* be called to complete the cycle. The node should not be
* added to the parent yet. The parent is supplied for
* logic related to "Who is my parent?".
*/
public Item createItem(Item parentItem);

/**
* Returns null if the item's modified value is valid.
* Otherwise returns a String describing the reason invalid.
* The value is a differnt instance from the one in the
* Item, so that if invalid there is nothing to undo.
*/
public String validateValue(Item item, Object value);

/**
* Returns null if the item's drillObject is valid. Otherwise
* returns an InvalidItem describing the reason invalid and
* containing field name with the problem. This allows the
* focus to go to that field to help the user.
* The drillObject is a differnt instance from the one in the
* Item, so that if invalid there is nothing to undo.
*/
public InvalidField validateDrillObject(Item item,
                                     Object drillObject);

/**
* Updates the stored state related to this item. Throws an
* exception if failure. The probable item state is that
* the value and/or drillObject have been modified.
*/
public void updateItem(Item item, Item parentItem);

/**
* Adds the item's state to storage and this collection. Throws
* an exception if failure. The item is the one created by 
* createItem(Item). This should add the item to the parent,
* which adds it to the collection.
*/
public void addItem(Item item, Item parentItem);

/**
* Moves the item to the newParentItem. 
*/
public void moveItem(Item item, Item newParentItem);

/**
* Removes the stored state related to this item and removes
* the item from the collection. 
*/
public void removeItem(Item item, Item parentItem);

/**
* Adds the listener for ItemTreeEvents.
*/
public void addItemTreeListener(ItemTreeListener listener);

/**
* Removes the listener for ItemTreeEvents.
*/
public void removeItemTreeListener(ItemTreeListener listener);

} // End interface 
