package org.jcon.df.edit.structure;

/**
 * Represents an event occuring during an ItemTreeSuppler 
 * edit. This is a polymorphic event.
 *
 * @author Jack Harich
 */
public class ItemTreeEvent {

//---------- Public Fields -------------------------------
public static final int ADDED     = 1;
public static final int UPDATED   = 2;
public static final int REMOVED   = 3;
public static final int MOVED     = 4;

//---------- Private Fields ------------------------------
private int      eventType;
private Item     item;
private Item     parentItem; // For ADDED, REMOVED, MOVED

//---------- Initialization ------------------------------
public ItemTreeEvent(int eventType, Item item) {
    this.eventType = eventType;
    this.item      = item;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == ADDED)   return "Added";
    if (eventType == UPDATED) return "Updated";
    if (eventType == REMOVED) return "Removed";    
    if (eventType == MOVED)   return "Moved";

    return "#UnknownType#";
}
//----- parentItem
public void setParentItem(Item parentItem) {
    this.parentItem = parentItem;
}
public Item getParentItem() {
    return parentItem;
}
//----- Other
public Item getItem() {
    return item;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ItemTreeEvent" + text);
}

} // End class
