package org.jcon.df.edit.structure;

import org.jcon.df.edit.control.element.ElementListModel;

/**
* The interface for suppliers of item list data structures,
* which are a list of Items.
*
* @author Jack Harich
*/
public interface ItemListSupplier extends StructureSupplier {

/**
* Returns the accessor for this supplier. The accessor is
* read only.
*/
// ***was public ItemListReader getItemListReader();

/**
* Returns the model for the list. The supplier should use
* this as its own list collection. This will cause model
* mutations to be reflected in the view automatically.
*/
public ElementListModel getElementListModel();

/**
* Returns a new Item initialized to default state. This is for
* allowing the user to add an Item. Later addItem(Item) will
* be called to complete the cycle.
*/
public Item createItem();

/**
* Returns null if the item's modified value is valid.
* Otherwise returns a String describing the reason invalid.
* The value is a differnt instance from the one in the
* Item, so that if invalid there is nothing to undo.
*/
public String validateValue(Item item, Object value);

/**
* Returns null if the item's drillObject is valid. Otherwise
* returns an InvalidItem describing the reason invalid and
* containing field name with the problem. This allows the
* focus to go to that field to help the user.
* The drillObject is a differnt instance from the one in the
* Item, so that if invalid there is nothing to undo.
*/
public InvalidField validateDrillObject(Item item, Object drillObject);

/**
* Updates the stored state related to this item. Throws an
* exception if failure. The probable item state is that
* the value and/or drillObject have been modified.
*/
public void updateItem(Item item);

/**
* Adds the item's state to storage and this collection. Throws
* an exception if failure. The item is the one created by 
* createItem(Item).
*/
public void addItem(Item item);

/**
* Moves the item to before the previousItem. If the previous
* item is null then the item becomes the first item. 
*/
public void moveItem(Item item, Item previousItem);

/**
* Removes the stored state related to this item and removes
* the item from the collection. 
*/
public void removeItem(Item item);

/**
* Adds the listener for ItemListEvents. *** May change
*/
public void addItemListListener(ItemListListener listener);

/**
* Removes the listener for ItemListEvents.
*/
public void removeItemListListener(ItemListListener listener);

} // End interface 
