package org.jcon.df.edit.structure;

import java.util.Vector;

/**
 * This class is a read only proxy for an ItemListSupplier.
 *
 * @author Jack Harich
 */

public class ItemListReader {

//---------- Private Fields ------------------------------
private Vector items;

//---------- Initialization ------------------------------
/**
* Creates a new instance and sets the items collection.
*/
public ItemListReader(Vector items) {
    this.items = items;
}
//---------- Properties ----------------------------------
/**
* Returns the number of items, which may be zero.
*/
public int getItemCount() {
    return items.size();
}
/**
* Returns the item at the specified index, which must be
* from zero to the count minus one.
*/
public Item getItemAt(int index) {
    return (Item)items.elementAt(index);
}


} // End class
