package org.jcon.df.edit.structure;

import org.jcon.df.edit.control.element.TreeElement;

/**
* This class is a logical member of a data collection. It
* is designed to support modern GUI data edits, including
* icons, drill down and delayed instantiation. Most
* importantly it allows seperation of GUI from Business
* Logic by use of the userObject, which the GUI sees as an
* object and the Business Logic layer sees as a specific type.
* <p>
* We extend TreeElement rather than Element so that this
* can be a list or node item.
*
* @author Jack Harich
*/
public class Item extends TreeElement {

//---------- Protected Fields ----------------------------
protected Object supplierObject;
protected Object iconType;

protected boolean           isDrillable;
protected StructureSupplier structureSupplier;
protected Object            drillObject;

//---------- Initialzation -------------------------------
public Item() {
    node.setUserObject(this);
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return displayValue.toString();
}
//---------- Properties ----------------------------------
//----- supplierObject
public void setSupplierObject(Object supplierObject) {
    this.supplierObject = supplierObject;
}
public Object getSupplierObject() {
    return supplierObject;
}
//----- iconType
public void setIconType(Object iconType) {
    this.iconType = iconType;
}
public Object getIconType() {
    return iconType;
}
//----- isDrillable
public void setDrillable(boolean isDrillable) {
    this.isDrillable = isDrillable;
}
public boolean isDrillable() {
    return isDrillable;
}
//----- structureSupplier
public void setStructureSupplier(StructureSupplier structureSupplier) {
    this.structureSupplier = structureSupplier;
}
public StructureSupplier getStructureSupplier() {
    return structureSupplier;
}
//----- drillObject
public void setDrillObject(Object drillObject) {
    this.drillObject = drillObject;
}
public Object getDrillObject() {
    if (drillObject == null) {
        structureSupplier.supplyDrillObject(this);
        
        if (drillObject == null) throw new IllegalStateException
            ("'" + structureSupplier.getStructureSupplierName() + 
             "' failed to supply drillObject.");
    }
    return drillObject;
}
//----- Other
public boolean isBehaviorSupported(Object behavior) {
    return structureSupplier.isBehaviorSupported(behavior, this);
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("Item" + text);
}

} // End class
