package org.jcon.df.edit.screen.std;

import org.jcon.ba.system.BeanActionInit;
import org.jcon.ba.system.BasketServices;
import org.jcon.ba.system.BeanPriv;
import org.jcon.df.edit.screen.WidgetDef;
import org.jcon.df.edit.screen.WidgetDefRegistry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
* This class contains a collection of named WidgetDefs.
* See WidgetDefRegistry for documentation.
*
* @author Jack Harich
*/
public class WidgetDefRegistryStd implements
    WidgetDefRegistry, BeanPriv, BeanActionInit {

//---------- Private Fields ------------------------------
// Properties
private BasketServices basketServices;
// Internal
// Key = widgetName, Object = WidgetDef
private Hashtable defs = new Hashtable();

//---------- WidgetDefRegistry Implementation ------------
//---------- Properties
public Enumeration getWidgetNames() {
    return defs.keys();
}
public boolean hasWidgetDef(String widgetName) {
    return defs.containsKey(widgetName);
}
//---------- Public Methods 
public void addWidgetDef(WidgetDef widgetDef) {
    String widgetName = widgetDef.getWidgetName();
    if (defs.containsKey(widgetName)) {
        throw new IllegalStateException("Cannot add WidgetDef"
        + " named '" + widgetName + "' since already exists.");
    } else {
        defs.put(widgetName, widgetDef);
    }
}
public WidgetDef getWidgetDef(String widgetName) {
    WidgetDef def = (WidgetDef)defs.get(widgetName);
    if (def == null) {
        throw new IllegalStateException("The WidgetDef"
        + " named '" + widgetName + "' was not found.");
    } else {
        return def;
    }
}
//---------- BeanPriv Implementation ---------------------
public void setBasketServices(BasketServices services) {
    basketServices = services;
}
//---------- BeanActionInit Implementation ---------------
public void init() {
    // Load WedgetDefs, which are children of this container
    Vector children = basketServices.getBranchBeanInstances("widgets");
    print(".init() - Adding " + children.size() + " widgets"); 
    for (int i = 0; i < children.size(); i++) {
        WidgetDef def = (WidgetDef)children.elementAt(i);
        addWidgetDef(def);
        //print(".init() - Added widget " + def.getWidgetName());
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("WidgetDefRegistryStd" + text);
}

} // End class
