package org.jcon.df.edit.screen.std;

import org.jcon.df.edit.EditEvent;
//import org.jcon.df.edit.module.CardPanel;
import org.jcon.df.edit.module.StackedBorderLayoutPanel;
import org.jcon.df.edit.screen.Sheet;
import org.jcon.df.edit.screen.WidgetDef;
import org.jcon.df.edit.screen.WidgetDefEvent;
import org.jcon.df.edit.screen.WidgetDefEventListener;
import org.jcon.df.edit.widget.Widget;
import org.jcon.util.msg.MessageListener;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;

/**
* This class provides services for a ScreenView,
* tricky since we are supporting dynamic Widgets. It
* also translates EditEvents into Messages for Screens.
* <p>
* We take a simple approach and only support 
* StackedBorderLayoutPanels for dynamically showing
* widgets that are "stacked" on the window.
*
* @author Jack Harich
*/ 
public class StackedWindowStd extends WindowStd
    implements Sheet, WidgetDefEventListener {

//---------- Private Fields ------------------------------
// Properties
private String          sheetName;
private MessageListener messageListener;
// Internal
private boolean         initialized;

// Key = widgetName, Object = StackedBorderLayoutPanel that has it
// This scheme allows us to show a widget given only its name
private Hashtable widgetMap = new Hashtable(); 

//---------- Superclass Overrides ------------------------
public void processEditEvent(EditEvent evt) {
    //print(".processEditEvent() - " + evt.getEventTypeString());
    int eventType = evt.getEventType();
    
    // Forward all events to messageListener
    if (messageListener != null) {
        messageListener.processMessage(evt.getMessage());        
    } else {
        print(".processEditEvent() - No messageListener to foward EditEvent to.");
    }          
}
public void actionPerformed(ActionEvent evt) {
    print(".actionPerformed() - " + evt.getActionCommand());
}
//---------- Sheet Implementation ------------------------
//----- Widgets
/**
* See <code>Sheet.addWidget(WidgetDef)</code> for documentation.
* For simplicity we ignore adds using a name that has
* already been added. We provide a default subPosition of
* "Center".
*/
public void addWidget(WidgetDef widgetDef) {
    checkInit();
    String widgetName = widgetDef.getWidgetName();
    
    // Ignore if already added
    if (getStackedPanel(widgetName) != null) return;
        
    // Get stackedPanel, put in widgetMap
    String position = (String)widgetDef.getWidgetPosition();
    //print(".addWidget() - Adding to position = " + position);
    StackedBorderLayoutPanel stackedPanel = 
        (StackedBorderLayoutPanel)widgetSet.getModule(position);    
    widgetMap.put(widgetName, stackedPanel);
    
    // Put in stackedPanel, add to widgetSet
    String subPosition = (String)widgetDef.getWidgetSubPosition();
    if (subPosition == null) subPosition = "Center";
    Widget topWidget = stackedPanel.addComponent(widgetName, subPosition, widgetDef.getWidgetParam());
    widgetSet.addTopWidget(topWidget);
    
    // Listen for WidgetDefEvent
    // ###widgetDef.addWidgetDefListener(this);
}
// This has gotten more complex than expected. We do NOT
// support top widgets, only sub top widgets. ***
public void processWidgetDefEvent(WidgetDefEvent evt) {
    if (evt.getEventType() != WidgetDefEvent.CHANGED) return;
    /*
    //----- Remove old widget
    checkInit();
    String widgetName = evt.getOldWidgetDef().getWidgetName();
    
    // Add widget only if not already added
    if (getStackedPanel(widgetName) != null) {
        addWidget(evt.getNewWidgetDef());
        return;
    }
    // Get stackedPanel, NO remove from widgetMap
    WidgetDef oldDef = evt.getOldWidgetDef();
    String position = (String)oldDef.getWidgetPosition();
    StackedBorderLayoutPanel stackedPanel = 
        (StackedBorderLayoutPanel)widgetSet.getModule(position);    
    //widgetMap.remove(widgetName);
    
    // Remove from stackedPanel and widgetSet
    //String subPosition = (String)oldDef.getWidgetSubPosition();
    //if (subPosition == null) subPosition = "Center";
    
    Widget topWidget = stackedPanel.getSubTopWidget(widgetName);
    widgetSet.removeSubTopWidget(topWidget);
    stackedPanel.removeSubTopWidget(widgetName);
    
    // Remove listener
    evt.getNewWidgetDef().removeWidgetDefListener(this);    
    
    //----- Add new widget same as before
    addWidget(evt.getNewWidgetDef()); */
}
/**
* Shows or hides the widgetNames, which must already be
* in the window using <code>addWidget(WidgetDef)</code>.
* For simplicity all widgetNames MUST be in the same
* StackedBorderLayoutPanel on this window.
*/
public void setWidgetsVisible(Vector widgetNames, boolean isVisible) {
    if (widgetNames.isEmpty()) return;
    // Get stackedPanel with first widgetName
    String firstName = (String)widgetNames.firstElement();
    StackedBorderLayoutPanel stackedPanel = 
        getStackedPanel(firstName);
    if (stackedPanel == null) {
        throw new IllegalArgumentException(
            "WidgetName + '" + firstName + "' not found.");
    }
    stackedPanel.showComponents(widgetNames);
}
// ----- sheetName
public void setSheetName(String sheetName) {
    this.sheetName = sheetName;
}
public String getSheetName() {
    return sheetName;
}
//----- visible 
public void setVisible(boolean isVisible) {
    checkInit();
    super.setVisible(isVisible);
}
// (isVisible() handled by superclass)

//----- Other
public void setMessageListener(MessageListener listener) {
    messageListener = listener;
}
// close() - Handled by superclass
// getWidgetSet() - Handled by superclass


//---------- Private Methods -----------------------------
private StackedBorderLayoutPanel getStackedPanel(String widgetName) {
    return (StackedBorderLayoutPanel)widgetMap.get(widgetName);
}
private void checkInit() {
    if (! initialized) {
        super.init();
        initialized = true;
    }
}
//--- Std
private static void print(String text) {
    System.out.println("StackedWindowStd" + text);
}

} // End class
