package org.jcon.df.edit.screen.std;

import org.jcon.df.edit.screen.Sheet;
import org.jcon.df.edit.screen.SheetRegistry;
import java.util.Enumeration;
import java.util.Hashtable;

/**
* This class contains a collection of named Sheets.
* See SheetRegistry for documentation.
*
* @author Jack Harich
*/
public class SheetRegistryStd implements SheetRegistry {

//---------- Private Fields ------------------------------
// Properties
private String defaultSheetName; // null if none
// Internal
// Key = sheetName, Object = Sheet
private Hashtable sheets = new Hashtable();

//---------- ScreenRegistry Implementation ---------------
//---------- Properties 
public Enumeration getSheetNames() {
    return sheets.keys();
}
public boolean hasSheet(String sheetName) {
    return sheets.containsKey(sheetName);
}
public void setDefaultSheetName(String sheetName) {
    defaultSheetName = sheetName;
}
public String getDefaultSheetName() {
    return defaultSheetName;
}
public Sheet getDefaultSheet() {
    if (defaultSheetName == null) throw new
        IllegalStateException("Cannot get default sheet" +
        " since no default sheet name has been set.");
    
    Sheet sheet = (Sheet)sheets.get(defaultSheetName);
    if (sheet == null) {
        throw new IllegalStateException("The default sheet"
        + " name of '" + defaultSheetName + "' was not found.");
    } else {
        return sheet;
    }
}
//---------- Public Methods
public void addSheet(Sheet sheet) {
    String sheetName = sheet.getSheetName();
    if (sheets.containsKey(sheetName)) {
        throw new IllegalStateException("Cannot add sheet"
        + " named '" + sheetName + "' since already exists.");
    } else {
        sheets.put(sheetName, sheet);
    }
}
public Sheet getSheet(String sheetName) {
    Sheet sheet = (Sheet)sheets.get(sheetName);
    if (sheet == null) {
        throw new IllegalStateException("The sheet"
        + " named '" + sheetName + "' was not found.");
    } else {
        return sheet;
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SheetRegistryStd" + text);
}

} // End class
