package org.jcon.df.edit.screen.std;

import org.jcon.df.edit.screen.Screen;
import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandContextStd;
import org.jcon.param.Param;
import org.jcon.param.ParamDrivenInfo;
import org.jcon.param.ParamDrivenSupply;
import org.jcon.param.ParamSupplier;
import org.jcon.util.DataLib;
import org.jcon.util.PropMap;
import org.jcon.util.PropMapStd;
import org.jcon.param.StringVector;
import org.jcon.util.msg.Message;
import java.util.Vector;

/**
* This class is a Menu style screen. Since no intricate
* policies are involved, it is easily ParamDriven.
*
* @author Jack Harich
*/
public class ScreenStd implements Screen, ParamDrivenSupply {

//---------- Private Fields ------------------------------
// Propeties
private ScreenContext context;
private ParamSupplier paramSupplier;
private Param         myParam;
private String        myScreenName;
// Internal
private String        mySheetName; // null for default
private boolean       widgetsAdded;
private PropMap       propMap;
private ScreenCommandContext screenCommandContext
                        = new ScreenCommandContextStd();

//---------- Screen Implementation -----------------------
public void setScreenContext(ScreenContext context) {
    this.context = context;
}
/**
* Sets the screen name. If this method is used, it 
* overrides the ScreenName in the Param.
*/
public void setScreenName(String name) {
    myScreenName = name;
}
public String getScreenName() {
    if (myScreenName != null) {
        return myScreenName;
    } else {
        getParam();
        return myParam.getString("ScreenName");
    }
}
public void startScreen(PropMap propMap) {
    if (propMap == null) {
        this.propMap = new PropMapStd();
    } else {
        this.propMap = propMap;
    }
    screenCommandContext.setScreenPropMap(this.propMap);
    context.setMessageListener(this, null);
    if (! widgetsAdded) {
        getParam();
        preloadWidgets();
        widgetsAdded = true;
    }
    doRequest("StartScreen");
}
public void processMessage(Message message) {
    String eventName = message.getName();
    //print(".processMessage() - Received " + eventName);
    if (eventName != "EditEvent") return;
    
    String eventType = message.getString("EventType").intern();
    
    if (eventType == "Command") {
        doRequest(message.getString("Command"));
        
    // See examples in HyperLinkMenuControl, JButtonControl
    // which are sources of this event
    } else if (eventType == "CommandParam") {
        Param cmdParam = (Param)message.get("Param");
        if (mySheetName != null) cmdParam.put("SheetName", mySheetName);
        context.doCommand(cmdParam, screenCommandContext);
            
    } else {
        print(".processMessage() - EventType " + eventType + " not yet implemented.");
    }
}
public String[] loadMessageInterests() {
    return new String[] { "EditEvent" };
}
//---------- ParamDrivenSupply Implementation ------------
public void setParam(Param param) {
    myParam = param;
}
public Param getParam() {
    if (myParam == null) {
        paramSupplier.supplyParam(this);
        paramSupplier = null;
        initParam();
    }
    return myParam;
}
public boolean applyNewParam(Param newParam) {
    myParam = newParam;
    initParam();
    return true; // Successful
}
public ParamDrivenInfo getParamDrivenInfo() {
    return null;
}
public void setParamSupplier(ParamSupplier paramSupplier) {
    this.paramSupplier = paramSupplier;
}
private void initParam() {
    mySheetName = myParam.getString("SheetName");
    widgetsAdded = false;
}
//---------- Private Methods -----------------------------
// Later change arg to Message to support complex events
private void doRequest(String requestName) {
    //print(".doRequest() - requestName = " + requestName);
    
    // Get commands for requestName
    Vector requestParams = myParam.getParamVector("Requests." + requestName );
    if (requestParams.isEmpty()) {
        // *** Later if null try getting from screenContext ***
        print(".doRequest() - '" + requestName + "' not found in myParam or is empty.");
        return;
    }        
    // Do commands in sequence
    for (int i = 0; i < requestParams.size(); i++) {
        Param cmdParam = (Param)requestParams.elementAt(i);
        //String cmdName = cmdParam.getString("CommandName").intern();
        
        // Note EventMessage not yet set in screenCommandContext
        context.doCommand(cmdParam, screenCommandContext);
    }
}
private void preloadWidgets() {
    String delimitedNames = myParam.getString("PreloadWidgets");
    if (delimitedNames == null) return;
    
    Vector names = DataLib.convertDelimStringToVector(
                        delimitedNames, ", ");
    for (int i = 0; i < names.size(); i++) {
        String name = (String)names.elementAt(i);
        print(".preloadWidgets() ------ Adding " + name);
        context.addWidget(name, mySheetName);
    }    
}
//--- Std
private static void print(String text) {
    System.out.println("ScreenStd" + text);
}

} // End class
