package org.jcon.df.edit.screen.std;

import org.jcon.ba.system.BeanActionInit;
import org.jcon.ba.system.BasketServices;
import org.jcon.ba.system.BeanPriv;
import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenService;
import org.jcon.df.edit.screen.ScreenServiceRegistry;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.msg.MessageRouter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
* This class contains a collection of named Screens.
* See ScreenServiceRegistry for documentation.
*
* @author Jack Harich
*/
public class ScreenServiceRegistryStd implements
    ScreenServiceRegistry, BeanPriv, BeanActionInit {

//---------- Private Fields ------------------------------
// Properties
private BasketServices basketServices;
private ScreenContext  screenContext;
// Internal
private MessageRouter router = new MessageRouter();
// Key = sheetName, Object = ScreenService
private Hashtable services = new Hashtable();

//---------- ScreenRegistry Implementation ---------------
//---------- Properties
public void setScreenContext(ScreenContext context) {
    screenContext = context;
}
public Enumeration getServiceNames() {
    return services.keys();
}
public boolean hasService(String name) {
    return services.containsKey(name);
}
//---------- Public Methods 
public void addService(ScreenService service) {
    String name = service.getServiceName();
    if (services.containsKey(name)) {
        throw new IllegalStateException("Cannot add service"
        + " named '" + name + "' since already exists.");
    } else {
        // Register service for its message interests
        router.addListenerInterests(service);
        
        service.setScreenContext(screenContext);
        services.put(name, service);
    }
}
public ScreenService getService(String name) {
    ScreenService service = (ScreenService)services.get(name);
    if (service == null) {
        throw new IllegalStateException("The service"
        + " named '" + name + "' was not found.");
    } else {
        return service;
    }
}
public void processMessage(Message message) {
    // Forward to my services by using router
    router.fire(message, this);
}
public String[] loadMessageInterests() {
    // Do later with router convenience method
    // such as getEventNamesForAllListeners().
    // Must do to support neutral MasterRegistry
    return new String[0]; 
}
//---------- BeanPriv Implementation ---------------------
public void setBasketServices(BasketServices services) {
    basketServices = services;
}
//---------- BeanActionInit Implementation ---------------
public void init() {
    // Load services, which are children of this container
    Vector childServices = basketServices.getBranchBeanInstances("services");
    for (int i = 0; i < childServices.size(); i++) {
        ScreenService service = (ScreenService)childServices.elementAt(i);
        addService(service);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ScreenServiceRegistryStd" + text);
}

} // End class
