package org.jcon.df.edit.screen.std;

import org.jcon.ba.system.BeanActionInit;
import org.jcon.ba.system.BasketServices;
import org.jcon.ba.system.BeanPriv;
import org.jcon.df.edit.screen.Screen;
import org.jcon.df.edit.screen.Sheet;
import org.jcon.df.edit.screen.ScreenRegistry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
* This class contains a collection of named Screens.
* See ScreenRegistry and ScreenContext for documentation.
*
* @author Jack Harich
*/
public class ScreenRegistryStd
    implements ScreenRegistry, BeanPriv, BeanActionInit {

//---------- Private Fields ------------------------------
// Properties
private BasketServices basketServices;
private String         primeScreenName;
// Internal
// Key = screenName, Object = Screen
private Hashtable screens = new Hashtable();

//---------- ScreenRegistry Implementation ---------------
//---------- Properties
public Enumeration getScreenNames() {
    return screens.keys();
}
public boolean hasScreen(String screenName) {
    return screens.containsKey(screenName);
}
public void setPrimeScreenName(String screenName) {
    primeScreenName = screenName;
}
public String getPrimeScreenName() {
    return primeScreenName;
}
public Screen getPrimeScreen() {
    if (primeScreenName == null) {
        throw new IllegalStateException("No prime screen name has been set.");
        
    } else {
        return getScreen(primeScreenName);
    }
}
//---------- Public Methods 
public void addScreen(Screen screen) {
    String screenName = screen.getScreenName();
    if (screens.containsKey(screenName)) {
        throw new IllegalStateException("Cannot add screen"
        + " named '" + screenName + "' since already exists.");
    } else {
        screens.put(screenName, screen);
    }
}
public Screen getScreen(String screenName) {
    Screen screen = (Screen)screens.get(screenName);
    if (screen == null) {
        throw new IllegalStateException("The screen"
        + " named '" + screenName + "' was not found.");
    } else {
        return screen;
    }
}
//---------- BeanPriv Implementation ---------------------
public void setBasketServices(BasketServices services) {
    basketServices = services;
}
//---------- BeanActionInit Implementation ---------------
public void init() {
    // Load screens, which are children of this container
    Vector children = basketServices.getBranchBeanInstances("screens");
    print(".init() - Adding " + children.size() + " screens");
    for (int i = 0; i < children.size(); i++) {
        Screen screen = (Screen)children.elementAt(i);
        addScreen(screen);
    }
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ScreenRegistryStd" + text);
}

} // End class
