package org.jcon.df.edit.screen.std;

import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.ScreenCommando;
import org.jcon.df.edit.screen.ScreenLogicRegistry;
import org.jcon.param.Param;
import org.jcon.param.ParamDriven;
import org.jcon.param.ParamDrivenInfo;
import org.jcon.util.DataLib;
import org.jcon.util.GenLib;
import java.util.Hashtable;
import java.util.Vector;

/**
* This class is the standard implementation of a
* ScreenLogicRegistry. See it for documentation.
* <p>
* *** NOTE - Later we will populate custom commandos
* and request Params from System Tree items the like 
* other registries.
*
* @author Jack Harich
*/
public class ScreenLogicRegistryStd implements
                    ScreenLogicRegistry, ParamDriven {

//---------- Private Fields ------------------------------
// Properties
private ScreenContext screenContext;
private Param         myParam;
// Internal
// Key = String name, Object = ScreenCommando
private Hashtable commandos = new Hashtable();

//---------- ScreenLogicRegistry Implementation ----------
//---------- Properties
public void setScreenContext(ScreenContext context) {
    screenContext = context;
}
//---------- Public Methods
//----- RequestParam
public void addRequestParam(String requestName, Param param) {
    print(".addRequestParam() - Not yet implemented");
}
public Param getRequestParam(String requestName) {
    print(".getRequestParam() - Not yet implemented");
    return null;
}
//----- ScreenCommand
public void addScreenCommando(String name, String className) {
    ScreenCommando commando = (ScreenCommando)
        GenLib.createInstance(className);
    addScreenCommando(name, commando);
}
public void addScreenCommando(String name, ScreenCommando commando) {
    if (commandos.containsKey(name)) throw new
        IllegalArgumentException("The command name '" +
        "' has already been added.");
        
    // Cannot setScreenContext here since null
    commando.setCommandName(name);
    commandos.put(name, commando);
}
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String commandName = cmdParam.getString("CommandName");
    if (commandName == null) throw new IllegalArgumentException
        ("The cmdParam doesn't contain a CommandName.");
        
    ScreenCommando commando = getCommando(commandName);
    if (commando == null) throw new IllegalArgumentException
        ("Command name '" + commandName + "' not found.");
        
    //print(".doCommand() - Commando named " + commando.getCommandName() + " for commandName " + commandName);            
    //print(".doCommand() - Commando is " + commando);
    commando.setScreenContext(screenContext); // Could optimize, set once
    commando.doCommand(cmdParam, cmdContext);
}
//---------- ParamDriven Implementation ------------------
public void setParam(Param param) {
    myParam= param;
    // Add commandos from class names
    // Line format is: CommandName, ClassName
    commandos.clear();
    Vector lines = myParam.getLinesVector("Commandos");
    for (int i = 0; i < lines.size(); i++) {
    
        String line = (String)lines.elementAt(i);
        String name = DataLib.getDelimitedField(line, 1, ", ");
        String className = DataLib.getDelimitedField(line, 2, ", ");
        
        addScreenCommando(name, className);
    }
}
public Param getParam() {
    return myParam; 
}
public boolean applyNewParam(Param newParam) {
    setParam(newParam);
    return true; // Successful
}
public ParamDrivenInfo getParamDrivenInfo() {
    return null;
}
//---------- Private Methods -----------------------------
private ScreenCommando getCommando(String name) {
    return (ScreenCommando)commandos.get(name);
}
//--- Std
private static void print(String text) {
    System.out.println("ScreenLogicRegistryStd" + text);
}


} // End class
