package org.jcon.df.edit.screen.std;

import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.ScreenCommando;
import org.jcon.param.Param;

/**
* This abstract class is the standard implementation of
* ScreenCommando. See it for documentation. Note the rather
* important plugpoint abstract method <code>doCommand()</code>.
*
* @author Jack Harich
*/
public abstract class ScreenCommandoStd implements ScreenCommando {

//---------- Protected Fields ----------------------------
// Properties
protected String        commandName;
protected ScreenContext screenContext;

//---------- ScreenCommando Implementation ---------------
//----- Implemented
public void setCommandName(String name) {
    commandName = name;
}
public String getCommandName() {
    return commandName;
}
public void setScreenContext(ScreenContext context) {
    screenContext = context;
}
//----- Abstract
public abstract boolean isScreenCommandContextNeeded();

public abstract void doCommand(Param cmdParam, ScreenCommandContext cmdContext);

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ScreenCommandoStd" + text);
}

} // End class
