package org.jcon.df.edit.screen.service;

import org.jcon.df.edit.control.InfoPaneControl;
import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenService;
import org.jcon.util.msg.Message;

/**
* This class provides an Information Pane service.
*
* @author Jack Harich
*/
public class InfoPaneService implements ScreenService {

//---------- Private Fields ------------------------------
// Propeties
private ScreenContext context;
private String        serviceName = "InfoPane"; // Default
// Internal
private String        currentText;
private String        defaultText; // null if none

//---------- ScreenService Implementation ----------------
public void setScreenContext(ScreenContext context) {
    this.context = context;
}
public String getServiceName() {
    return serviceName;
}    
public void processMessage(Message message) {
    String messageName = message.getName();
    if (messageName == "SetInfoText") {
        setInfoText(message);
    } else {
        print(".processMessage() - Ignoring Message named " + messageName);
    }
}
public String[] loadMessageInterests() {
    return new String[] { "SetInfoText" };
}
//---------- Properties ----------------------------------
public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
}
//---------- Private Methods -----------------------------
private void setInfoText(Message message) {
    //print(".showInfoText() - Entered" + " context = " + context);
    
    if (message.isTrueDefault("IsDefaultText", false)) {
        defaultText = message.getString("Text");
        //print(".setInfoText() - defaultText = " + defaultText);
        if (currentText == null) setText(defaultText);
        return;
    }
    // Show the message text or our defaultText if null
    String text = message.getString("Text");
    if (text == null) text = defaultText;
    setText(text);
    
    // *** Later we will be ParamDriven and have
    // various icons. Get IconName from Message.
    //infoPane.setIcon(getIcon(iconName));
}
private void setText(String text) {
    // null for default sheet
    // *** Will have to introduce sheetName property
    InfoPaneControl infoPane = (InfoPaneControl)context
        .getWidgetSet(null).getControl("InfoPane");

    infoPane.setValue(text);
    currentText = text;
}
//--- Std
private static void print(String text) {
    System.out.println("InfoPaneService" + text);
}

} // End class
