package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.util.PropMap;
import org.jcon.util.msg.Message;

/**
* This class starts a screen.
*
* @author Jack Harich
*/
public class StartScreen extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return true;
}
// cmdContext is used
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String screenName = cmdParam.getString("ScreenName");
    PropMap propMap = cmdContext.getScreenPropMap();
    
    // Note the clone, to protect the calling screen
    propMap = (PropMap)propMap.clone();
        
    //print(".doCommand() - Starting screen " + screenName);
    screenContext.startScreen(screenName, propMap); 
    
    // Erase info text. This will cause the new default to appear.
    // See use in ScreenStd
    Message newMessage = new Message("SetInfoText");
    newMessage.set("Text", null);
    // *** IconName later, feature not implemented in InfoTextPane
    screenContext.sendMessage(newMessage);    
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ShowWidgets" + text);
}


} // End class
