package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.util.DataLib;
import java.util.Vector;

/**
* This class shows several widget names at a time.
*
* @author Jack Harich
*/
public class ShowWidgets extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String sheetName = cmdParam.getString("SheetName");
    String delimitedNames = cmdParam.getString("WidgetNames");
    Vector names = DataLib.convertDelimStringToVector(
                        delimitedNames, ", ");
    
    screenContext.setWidgetsVisible(names, sheetName, true);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ShowWidgets" + text);
}


} // End class
