package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.util.msg.Message;

/**
* This class sets the text used by the InfoPane.
* Note the option to set the default text, which
* is shown if the text is set to none.
*
* @author Jack Harich
*/
public class SetInfoText extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String sheetName = cmdParam.getString("SheetName");
    String infoText = cmdParam.getLinesVectorString("InfoText", " ");
    boolean isDefaultText = cmdParam.isTrueDefaultFalse("IsDefaultText");
    
    // See use in ScreenStd
    Message newMessage = new Message("SetInfoText");
    newMessage.set("Text", infoText);
    newMessage.setBoolean("IsDefaultText", isDefaultText);
    // *** IconName later, feature not implemented in InfoTextPane
    screenContext.sendMessage(newMessage);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SetControlValue" + text);
}


} // End class
