package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.util.PropMap;

/**
* This class sets a control value.
*
* @author Jack Harich
*/
public class SetControlValueFromPropMap extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return true;
}
// cmdContext is used
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String sheetName = cmdParam.getString("SheetName");
    PropMap propMap = cmdContext.getScreenPropMap();
    
    String controlName = cmdParam.getString("ControlName");
    String propMapKey = cmdParam.getString("PropMapKey");
        
    screenContext.getWidgetSet(sheetName).setControlValue
        (controlName, propMap.get(propMapKey));
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SetControlValueFromPropMap" + text);
}


} // End class
