package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;

/**
* This class sets a Control's value.
*
* @author Jack Harich
*/
public class SetControlValue extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String controlName = cmdParam.getString("ControlName");
    String sheetName = cmdParam.getString("SheetName");
    String controlValue = cmdParam.getString("ControlValue");
    
    screenContext.getWidgetSet(sheetName).setControlValue
        (controlName, controlValue);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SetControlValue" + text);
}


} // End class
