package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;

/**
* This class sets a Control's enabled state.
*
* @author Jack Harich
*/
public class SetControlEnabled extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String controlName = cmdParam.getString("ControlName");
    boolean isEnabled = cmdParam.isTrue("IsEnabled");
    
    // null if not declared, which gives the defaultSheet
    String sheetName = cmdParam.getString("SheetName");
    
    screenContext.getWidgetSet(sheetName).setControlEnabled
        (controlName, isEnabled);

    //print(".doCommand() - Good news, it worked!");
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SetControlEnabled" + text);
}


} // End class
