package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;

/**
* This class requests a Control's focus.
* <p>
* Note - Swing bug, caret doesn't blink sometimes.
* Also - Selects entire value if any. - This is a "feature".
*
* @author Jack Harich
*/
public class RequestControlFocus extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String controlName = cmdParam.getString("ControlName");
    String sheetName = cmdParam.getString("SheetName");
    
    screenContext.getWidgetSet(sheetName).requestControlFocus
        (controlName);

    //print(".doCommand() - Good news, it worked!");
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("RequestControlFocus" + text);
}


} // End class
