package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.control.Control;
//import org.jcon.df.edit.control.JButtonControl;
import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.ui.comp.DoClickable;

// For paint fix
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JRootPane;
//import javax.swing.SwingUtilities;
//import org.jcon.ui.VisualLib;
//import java.awt.Component;
//import javax.swing.JFrame;
//import java.awt.Toolkit;

/**
* This class simulates a user click on a variety of controls.
* The control must implement the DoClickable interface.
*
* @author Jack Harich
*/
public class DoClick extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return false;
}
// cmdContext is not needed
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {
    String controlName = cmdParam.getString("ControlName");
    String sheetName = cmdParam.getString("SheetName");
    int pressTime = cmdParam.getIntDefaultZero("PressTime");
    //print(".doCommand() - controlName = " + controlName);
    
    Control control = screenContext
        .getWidgetSet(sheetName).getControl(controlName);
    if (control instanceof DoClickable) {
        ((DoClickable)control).doClick(pressTime);
    } else {
        print(".doCommand() -----> The control named '" + controlName +
        "' is not a DoClickable.");
    }
}    
    // Allow event to take effect
    // Tried: sleep current Thread, Toolkit.sync(),
    // JComponent.paintImmediately(). Validated all parents
    // are JComponents with VisualLib.findTopContainer()
    
    // paintImmediately() on each parent. This works in
    // JButton. It fails the first time a component is shown.
    // This is a Swing bug.
    // This worked but we now have workarond in Test.
//    Container parent = control.getComponent().getParent();
//    while (parent != null) {
//        //print(" - parent = " + parent.getClass().getName());
//        if (parent instanceof JComponent) {
//            ((JComponent)parent).paintImmediately
//                (parent.getBounds());
//        }
//        if (parent instanceof JRootPane) break;
//        if (parent.getParent() == null) {
//            break;
//        } else {
//            parent = parent.getParent();
//        }
//    }   
    // These all failed.        
    //Component comp = VisualLib.findTopContainer(control.getComponent());
    //((JFrame)comp).getRootPane().paintImmediately(comp.getBounds());
    
    //JRootPane rootPane = SwingUtilities.getRootPane(control.getComponent());
    //print(" - bounds = " + rootPane.getBounds());
    //rootPane.paintImmediately(rootPane.getBounds());
    
    //Toolkit.getDefaultToolkit().sync();
    
    /*try {
        Thread.currentThread().sleep(500);
    } catch(Exception ex) {
        // Ignore
    }*/
//}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("DoClick" + text);
}


} // End class
