package org.jcon.df.edit.screen.commando;

import org.jcon.df.edit.screen.ScreenCommandContext;
import org.jcon.df.edit.screen.std.ScreenCommandoStd;
import org.jcon.param.Param;
import org.jcon.util.PropMap;

/**
* This class adds a control value to the screen PropMap.
*
* @author Jack Harich
*/
public class AddControlValueToPropMap extends ScreenCommandoStd {

//---------- Abstract Implementations --------------------
public boolean isScreenCommandContextNeeded() {
    return true;
}
// cmdContext is used
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext) {

    String sheetName = cmdParam.getString("SheetName");
    PropMap propMap = cmdContext.getScreenPropMap();
    
    String controlName = cmdParam.getString("ControlName");
    String controlValue = cmdParam.getString("ControlValue");
    String propMapKey = cmdParam.getString("PropMapKey");
    Object value = screenContext.getWidgetSet(sheetName)
        .getControlValue(controlName);
        
    propMap.set(propMapKey, value);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("AddControlValueToPropMap" + text);
}


} // End class
