package org.jcon.df.edit.screen.autotest;

import org.jcon.param.Param;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageRouter;
import org.jcon.util.msg.MessageRouterRegistry;

/**
* This class provides a Test with its context. This is the
* only way the Test can use the rest of the test subsystem.
* <p>
* This class is the bridge between the AutoText subsystem
* and the system being tested. Currently we use the
* MessageRouterRegistry as the entry point to the other
* system, which must listen to Messages in the 
* SingletonDefaultRouter named "DoScreenCommand".
*
* @author Jack Harich
*/
public class TestContext {

//---------- Private Fields ------------------------------
// Internal
private boolean       initialized;
private MessageRouter messageRouter;

//---------- Public Methods ------------------------------
/**
* Performs the command represented in the Param. This must
* follow the format expected by the receipient. In this 
* case the receipient will be a ScreenCommando in the
* Modular Screen Subsystem.
*/
public void doCommand(Param cmdParam) {
    if (! initialized) init();
    
    Message message = new Message("DoScreenCommand");
    message.set("CommandParam", cmdParam);
    //print(".doCommand() - Before firing message");
    messageRouter.fire(message, this);
}
//---------- Private Methods -----------------------------
private void init() {
    messageRouter = MessageRouterRegistry.getSingletonDefaultRouter();
    initialized = true;
}
//--- Std
private static void print(String text) {
    System.out.println("TestContext" + text);
}

} // End class