package org.jcon.df.edit.screen;

import java.util.Enumeration;

/**
* This class is a registry for WidgetDefs.
*
* @author Jack Harich
*/
public interface WidgetDefRegistry {

//---------- Properties ----------------------------------
/**
* Returns all the widget names in the registry.
*/
public Enumeration getWidgetNames();

/**
* Returns true if the registry has the named widget,
* false if not.
*/
public boolean hasWidgetDef(String widgetName);


//---------- Public Methods ------------------------------
/**
* Adds the WidgetDef to the registry. The def's name must
* be unique per registry. Throws an IllegalStateException
* if already in the registry.
*/
public void addWidgetDef(WidgetDef widgetDef);

/**
* Returns the named WidgetDef. Throws an IllegalStateException
* if not found, since this is usually a programming error.
*/
public WidgetDef getWidgetDef(String widgetName);



} // End interface
