package org.jcon.df.edit.screen;

/**
* This class is a polymorphic event representing a change
* in a WidgetDef.
*
* @author Jack Harich
*/
public class WidgetDefEvent {

//---------- Public Fields -------------------------------
/**
* Signifies the WidgetDef has changed.
* Uses the properties OldWidgetDef and NewWidgetDef.
*/
public static final int CHANGED = 1;

//---------- Private Fields ------------------------------
private int       eventType;
private WidgetDef oldWidgetDef;
private WidgetDef newWidgetDef;

//---------- Initialization ------------------------------
public WidgetDefEvent(int eventType) {
    this.eventType = eventType;
}
//---------- Superclass Overrides ------------------------
public String toString() {
    return getEventTypeString();
}
//---------- Properties ----------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
public String getEventTypeString() {
    if (eventType == CHANGED) return "Changed";

    return "#UnknownType#";
}
//----- oldWidgetDef
public void setOldWidgetDef(WidgetDef widgetDef) {
    oldWidgetDef = widgetDef;
}
public WidgetDef getOldWidgetDef() {
    return oldWidgetDef;
}
//----- newWidgetDef
public void setNewWidgetDef(WidgetDef widgetDef) {
    newWidgetDef = widgetDef;
}
public WidgetDef getNewWidgetDef() {
    return newWidgetDef;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("WidgetDefEvent" + text);
}

} // End class
