package org.jcon.df.edit.screen;

import org.jcon.param.Param;

/**
* This interface defines a single widget, which is a
* Control or Module.
*
* @author Jack Harich
*/
public interface WidgetDef {

/**
* Returns a shallow copy of the instance.
*/
public Object clone();

/**
* Sets the name of the widget, which must be unique
* per view.
*/
public void setWidgetName(String name);

/**
* Returns the name of the widget, which must be unique
* per view.
*/
public String getWidgetName();

/**
* The position defines the position of the widget in the
* view. The position must already exist in the view.
* Examples are "WorkPane" and "InfoPane". Note you should
* use logical rather than physical positions to allow for
* change.
* <p>
* The return type of Object allows for complex
* positioning, such as nesting and dynamic.
*/
public Object getWidgetPosition();

/**
* This defines a position sub area to allow one level
* nesting. SubPositions are for complex nested layouts, 
* and are optional.
* <p>
* For example a Position could be "WorkPane" and a
* SubPosition could be "South". This would
* put the widget in the Sourth area of the WorkPane.
*/
public Object getWidgetSubPosition();

/**
* Returns the Param used to create the widget.
*/
public Param getWidgetParam();

/**
* Adds the listener for WidgetDefEvents.
*/
public void addWidgetDefListener(WidgetDefEventListener listener);

/**
* Removes the listener for WidgetDefEvents.
*/
public void removeWidgetDefListener(WidgetDefEventListener listener);


} // End interface
