package org.jcon.df.edit.screen;

import java.util.Enumeration;

/**
* This interface contains a collection of named Sheets.
* Sheet names MUST be unique per registry.
*
* @author Jack Harich
*/
public interface SheetRegistry {

//---------- Properties ----------------------------------
/**
* Returns an Enumeration of Strings representing the sheet
* names in the registry, unsorted.
*/
public Enumeration getSheetNames();

/**
* Returns true if has the named sheet, false if not.
*/
public boolean hasSheet(String sheetName);

/**
* Sets the default sheet name used by getDefaultSheet().
* null may be used to "unset" the default sheet name.
*/
public void setDefaultSheetName(String sheetName);

/**
* Returns the default sheet name or null if none.
*/
public String getDefaultSheetName();

/*
* Returns the default sheet or throws an IllegalStateException
* if not found or no default sheet name has been set.
* Default sheets are useful for single sheet systems, such
* as a single window or Applet for an application.
*/
public Sheet getDefaultSheet();

//---------- Public Methods ------------------------------
/**
* Adds the sheet to the registry. The sheet's name must
* be unique per registry. Throws an IllegalStateException
* if already in the registry.
*/
public void addSheet(Sheet sheet);

/**
* Returns the named sheet. Throws an IllegalStateException
* if not found, since this is usually a programming error.
*/
public Sheet getSheet(String sheetName);



} // End interface
