package org.jcon.df.edit.screen;

import org.jcon.df.edit.widget.WidgetSet;
import org.jcon.param.Param;
import org.jcon.util.msg.MessageListener;
import java.util.Vector;

/**
* This interface defines a single sheet of widgets. The
* implementation may be a window, an Applet, a tab, etc.
* Widget names MUST be unique per sheet.
*
* @author Jack Harich
*/
public interface Sheet {

//---------- Properties ----------------------------------
/**
* Sets the name of the sheet, which must be unique
* per SheetRegistry.
*/
public void setSheetName(String sheetName);

/**
* Returns the name of the sheet, which must be unique
* per SheetRegistry.
*/
public String getSheetName();

/**
* Shows and hides the sheet. This is useful for windows
* and tabs or cards. It is not useful for Applets.
*/
public void setVisible(boolean visible);

/**
* Related to setVisible().
*/
public boolean isVisible();

/**
* Sets the single MessageListener for Message events.
*/
public void setMessageListener(MessageListener listener);

/**
* Returns the widget set for this sheet.
*/
public WidgetSet getWidgetSet();

//---------- Public Methods ------------------------------
/**
* Adds the widget to its position in this sheet. If
* already in this window then there is no effect. This
* method can be used to preload a window for later speed.
*
* @param widgetDef defines the widget. It may be a control
*    or Module. The name in the widget must be unique per
*    sheet.
*/
public void addWidget(WidgetDef widgetDef);

/**
* Shows or hides the widgetNames, which must already be
* in the window using <code>addWidget(WidgetDef)</code>.
* For simplicity all widgetNames MUST be in the same
* StackedBorderLayoutPanel on this window.
*/
public void setWidgetsVisible(Vector widgetNames, boolean isVisible);

/**
* Directs the sheet to close itself and prepare for
* garbage collection.
*/
public void close();


} // End interface
