package org.jcon.df.edit.screen;

import org.jcon.util.msg.MessageListener;
import java.util.Enumeration;

/**
* This interface contains a collection of named
* ScreenServicess. Names MUST be unique per registry.
*
* @author Jack Harich
*/
public interface ScreenServiceRegistry
                            extends MessageListener {

//---------- Properties ----------------------------------
/**
* Sets the all important ScreenContext.
*/
public void setScreenContext(ScreenContext context);

/**
* Returns an Enumeration of Strings representing the service
* names in the registry, unsorted.
*/
public Enumeration getServiceNames();

/**
* Returns true if has the named service, false if not.
*/
public boolean hasService(String name);

//---------- Public Methods ------------------------------
/**
* Adds the screen to the registry. The screen's name must
* be unique per registry. Throws an IllegalStateException
* if already in the registry.
*/
public void addService(ScreenService service);

/**
* Returns the named service. Throws an IllegalStateException
* if not found, since this is usually a programming error.
*/
public ScreenService getService(String screenName);

// in super - public void processMessage(Message message);

// in super - public String[] loadMessageInterests();



} // End interface
