package org.jcon.df.edit.screen;

import org.jcon.util.msg.MessageListener;

/**
* This interface defines a single service used by the
* Modular Screen System. Examples of services are 
* InfoPane, LocaleMgr, DataFascade and HelpSystem.
* <p>
* MessageInterests will be fulfilled by the 
* ScreenServiceRegistry. The service does not have to add
* itself as a listener - this is done automatically by
* the registry.
*
* @author Jack Harich
*/
public interface ScreenService extends MessageListener {

//---------- Properties ----------------------------------
/**
* Sets the context for this service. This is the only way
* the service can use the rest of the system.
*/
public void setScreenContext(ScreenContext context);

/**
* Returns the service name, which must be unique per system.
*/
public String getServiceName();

//---------- Public Methods ------------------------------

// in super - public void processMessage(Message message);

// in super - public String[] loadMessageInterests();

} // End interface

/*


import org.jcon.df.edit.screen.ScreenContext;
import org.jcon.df.edit.screen.ScreenService;
import org.jcon.util.msg.Message;

//---------- Screen Implementation -----------------------
public void setScreenContext(ScreenContext context) {
    this.context = context;
}
public String getServiceame() {
    return "***MyName***";
}
public void processMessage(Message message) {
    // *** Do
}
public String[] loadMessageInterests() {
    return new String[] { "***InterestName" };
}

*/
