package org.jcon.df.edit.screen;

import java.util.Enumeration;

/**
* This interface contains a collection of named Screens.
* Screen names MUST be unique per registry.
*
* @author Jack Harich
*/
public interface ScreenRegistry {

//---------- Properties ----------------------------------
/**
* Returns an Enumeration of Strings representing the screen
* names in the registry, unsorted.
*/
public Enumeration getScreenNames();

/**
* Returns true if has the named screen, false if not.
*/
public boolean hasScreen(String screenName);

/**
* Sets the prime screen name. This is a required config.
* The prime screen is the first one started in a system.
* There should be only one prime screen in a system.
*/
public void setPrimeScreenName(String screenName);

/**
* Returns the prime screen name or null if none.
*/
public String getPrimeScreenName();

/*
* Returns the prime screen or throws an IllegalStateException
* if not found. 
*/
public Screen getPrimeScreen();

//---------- Public Methods ------------------------------
/**
* Adds the screen to the registry. The screen's name must
* be unique per registry. Throws an IllegalStateException
* if already in the registry.
*/
public void addScreen(Screen screen);

/**
* Returns the named screen. Throws an IllegalStateException
* if not found, since this is usually a programming error.
*/
public Screen getScreen(String screenName);



} // End interface
