package org.jcon.df.edit.screen;

import org.jcon.param.Param;

/**
* This interface contains the configurable logic Screens
* need to do their work. This is a careful step towards
* the Dynamic Logic vision.
*
* @author Jack Harich
*/
public interface ScreenLogicRegistry {

//---------- Properties ----------------------------------
/**
* Sets the ScreenContext the registry uses. For example
* each Commando is given this context reference.
*/
public void setScreenContext(ScreenContext context);

//---------- Public Methods ------------------------------
//----- RequestParam
/**
* Adds the param to the collection of "request params". 
* These are screen requests used by many screens, and so
* are reusable. The name must be unique per registry.
* See a Screen parex file for typical requests.
*/
public void addRequestParam(String requestName, Param param);

/**
* Returns the Param containing the command params that
* make up the request.
*/
// *** public Param getRequestParam(String requestName);

//----- ScreenCommand
/**
* Adds the Commando to the registry using the className,
* which must implement ScreenCommando.
* The name must be unique per registry. Throws an 
* IllegalStateException if the name is already in the registry.
*/
public void addScreenCommando(String name, String className);

/**
* Same as the other addCommando() except the instance is
* provided.
*/
public void addScreenCommando(String name, ScreenCommando commando);

//----- Other
/**
* Performs the CommandName in the Param using the context
* and the Param. The context may be null for commands not
* needing it, which is very useful for command coming from
* sources besides screens such as Auto Test.
*/
public void doCommand(Param cmdParam, ScreenCommandContext context);

/**
* Returns the Param containing the command params that
* make up the request.
*/
public Param getRequestParam(String requestName);


} // End interface
