package org.jcon.df.edit.screen;

import org.jcon.df.edit.widget.WidgetSet;
import org.jcon.param.Param;
import org.jcon.util.PropMap;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageListener;
import java.util.Enumeration;
import java.util.Vector;

/**
* This interface provides the various ways a Screen can
* collaborate with the rest of the system. Basic and
* convenience methods are provided.
* <p>
* The SheetRegistry may have a default sheet name. If null
* is passed as the sheetName in a method, it will be
* replaced by the default sheet name. This allows single
* sheet systems to be more easily implemented.
*
* @author Jack Harich
*/
public interface ScreenContext {

//---------- Public Methods ------------------------------
/**
* Returns the named sheet, for various use.
* A null sheetName will return the default sheet.
*/
public Sheet getSheet(String sheetName);

/**
* Adds the widget to the sheet, but does not reveal it.
* If not already on the sheet, it will be automatically 
* added to the sheet. This allows behinds the scenes
* perparation for later apparent speed.
* A null sheetName will use the default sheet.
*/
public void addWidget(String widgetName, String sheetName);

/**
* Shows or hides the widgets on the sheet. 
* A null sheetName will use the default sheet.
*/
public void setWidgetsVisible(Vector widgetNames,
                String sheetName, boolean isVisible);

/**
* Returns the WidgetSet for the named sheet. This allows
* the screen to manipulate the widgets directly.
* A null sheetName will use the default sheet.
*/
public WidgetSet getWidgetSet(String sheetName);

/**
* Shows or hides the named sheet.
* A null sheetName will use the default sheet.
*/
public void setSheetVisible(String sheetName, boolean isVisible);

/**
* Starts the named screen. This is the key to workflow.
* This will cause startScreen() to be called on the named
* screen. The propMap is used to pass state to the next Screen.
*/
public void startScreen(String screenName, PropMap propMap);

/**
* Sets the listener for all events.
* A null sheetName will use the default sheet.
*/
public void setMessageListener(MessageListener listener,
    String sheetName);

/**
* Sends the Message, which may be any type of Message,
* such as Acquire, Command or Notify.
*/
public void sendMessage(Message message);

/**
* Performs the CommandName in the Param using the context
* and the Param. The context may be null for commands not
* needing it, which is very useful for command coming from
* sources besides screens such as Auto Test.
*/
public void doCommand(Param cmdParam, ScreenCommandContext cmdContext);

/**
* Returns the Param containing the command params that
* make up the request.
*/
public Param getRequestParam(String requestName);


} // End interface
