package org.jcon.df.edit.screen;

import org.jcon.param.Param;

/**
* This humorously but accurately named interface defines a
* "commando", which can perform
* a single command. A commando is a "atomic" class
* since all of it is exercised whenever it is called.
* It has a single, narrow responsibility.
* It is the extreme of the rule that, "A class
* does one thing and does it well".
* <p>
* This is a subsystem plugpoint. Unlike the Screen and
* WidgetDef plugpoints that are filled by parex files,
* this plugpoint is expected to be filled by implementations.
* Thus ScreenCommandoStd is abstract. Hmmmmm, I wonder if
* the ultimate plugpoint framework has either ParamDriven
* or atomic plugpoints?
*
* @author Jack Harich
*/
public interface ScreenCommando {

//---------- Properties ----------------------------------
/**
* Sets the name of the command for later external use. 
* The name should NOT be used internally for logic, such
* as for a single class handling multiple commands based on the
* command name. Otherwise changing the name would break
* the class. The name may be used for debugging.
*/
public void setCommandName(String name);

/**
* Returns the name of the command.
*/
public String getCommandName();

/**
* Returns true if ScreenCommandContext is needed in
* doCommand(), false if it may be null. This allows us to
* differentiate between the two main types of commands:
* those originating from Screens and others, such as
* Auto Test.
*/
public boolean isScreenCommandContextNeeded();

/**
* Sets the ScreenContext used when performing the command.
*/
public void setScreenContext(ScreenContext context);

//---------- Public Methods ------------------------------

/**
* Performs the CommandName in the Param using the context
* and the Param. The context may be null for commands not
* needing it, which is very useful for command coming from
* sources besides screens such as Auto Test.
* <p>
* Note - Identical to <code>ScreenLogicRegistry.doCommand
* (Param, ScreenCommandContext) </code>.
*/
public void doCommand(Param cmdParam, ScreenCommandContext context);

} // End interface
