package org.jcon.df.edit.screen;

import org.jcon.util.PropMap;
import org.jcon.util.msg.Message;

/**
* This interface defines the context to use in performing
* a Screen command. The context is the internal state and
* other state the source of the command chooses to expose.
* In our first design we assume that the source is a
* Screen. This will probably change as this subsystem evolves.
*
* @author Jack Harich
*/
public interface ScreenCommandContext {

//---------- Properties ----------------------------------
/**
* Sets the screen's properties. These contain key values
* such as data on a screen.
*/
public void setScreenPropMap(PropMap propMap);

/**
* Returns the screen's PropMap.
*/
public PropMap getScreenPropMap();

/**
* Sets the event Message resulting in this command. For
* some commands such as actions, there is nothing in the
* Message.
*/
public void setEventMessage(Message message);

/**
* Returns the event Message.
*/
public Message getEventMessage();



} // End interface
