package org.jcon.df.edit.screen;

import org.jcon.util.PropMap;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageListener;

/**
* This interface defines a single logical "screen", A
* screen is one or more Widgets arranged in a Sheet.
* It offers the user a particular function, such as a
* menu or step.
* <p>
* A screen does two things: start working by setting up
* a logical screen for the user, and then processing
* events from that screen. This continues until the
* screen starts another screen.
*
* @author Jack Harich
*/
public interface Screen extends MessageListener {

//---------- Properties ----------------------------------
/**
* Sets the context for this screen. This is the only way
* the screen can use the rest of the system.
*/
public void setScreenContext(ScreenContext context);

/**
* Sets the screen name, which must be unique per system.
*/
public void setScreenName(String name);

/**
* Returns the screen name, which must be unique per system.
*/
public String getScreenName();

//---------- Public Methods ------------------------------
/**
* The screen should start working. The steps expected are: <p> <pre>
* - Put the proper widgets into the sheet
* - Populate those widgets with data
* - Disable/enable widgets as necessary
* - Save state as needed to process events
* - Show the sheet
* - Request focus for a widget on the sheet
* </pre> <p>
* Many of these steps are optional. Other steps are possible.
* This is just to give you the flavor of what start does.
*/
public void startScreen(PropMap propMap);

/**
* The screen should process the message event appropriately.
* Typical steps would be: <p> <pre>
* - Filter the Message and ignore most
* - Validate data in widgets on the current sheet
* - If problems are encountered, complain
* - Save state as necessary
* - If done, start the next screen, passing input data </pre>
*/
// in super - public void processMessage(Message message);

// in super - public String[] loadMessageInterests();

} // End interface

/*
// The following may be obsolete:

import org.jcon.df.edit.screen.Screen;
import org.jcon.util.msg.Message;

//---------- Screen Implementation -----------------------
public void setScreenContext(ScreenContext context) {
    this.context = context;
}
public boolean isPrimeScreen() {
    return false;
}
public String getScreenName() {
    return "***MyName***";
}
public void startScreen() {
    // *** Do
}
public void processMessage(Message message) {
    // *** Do
}
public String[] loadMessageInterests() {
    return new String[] { "***InterestName" };
}

*/
