package org.jcon.df.edit.screen;

import org.jcon.util.msg.MessageListener;

/**
* This interface defines a collection of registries and
* manages the ScreenContext. It is the hub for the Modular
* Screen Subsystem.
*
* @author Jack Harich
*/
public interface MasterRegistry {

//---------- Properties ----------------------------------
/**
* Sets a system's SheetRegistry, which is required.
*/
public void setSheetRegistry(SheetRegistry registry);

/**
* Sets a system's ScreenRegistry, which is required.
*/
public void setScreenRegistry(ScreenRegistry registry);

/**
* Sets a system's WidgetDefRegistry, which is required.
*/
public void setWidgetDefRegistry(WidgetDefRegistry registry);

/**
* Sets a system's ScreenLogicRegistry, which is required.
*/
public void setScreenLogicRegistry(ScreenLogicRegistry registry);

/**
* Sets a system's ScreenServiceRegistry, which is optional.
*/
public void setScreenServiceRegistry(ScreenServiceRegistry registry);

//---------- Public Methods ------------------------------
/**
* Starts the primordial screen for a system. This depends
* on the isPrimeScreen() property in Screen. The effect is
* the first screen is shown. 
* <p>
* We use this technique for starting a system since is is 
* flexible. For example the prime screen can be determined
* at runtime or configured differently per customer.
*/
public void startPrimeScreen();


} // End interface
