package org.jcon.df.edit.module;

import org.jcon.param.*;
import java.awt.*;

/**
 * Unit test for TabPanel.
 *    java org.jcon.df.edit.module.TabPanelTest
 *
 * @author Jack Harich
 */
public class TabPanelTest {

//---------- Private Fields ------------------------------

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new TabPanelTest().runUnitTest();   
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    Frame frame = new Frame("TabPanel Unit Test");
    TabPanel tabPanel = new TabPanel();
    tabPanel.setParam(getTestParam());
    frame.add("Center", tabPanel.getComponent());
    frame.pack();
    frame.setVisible(true);
}
//---------- Private Methods -----------------------------
private Param getTestParam() {
    String text = "" +
    
    "IsModule is: true\n" +
    "Type is: TabPanel\n" +
    "Style is: Default\n" +
    "AddType is: EndRow\n" +
    "Tabs has:\n" +
    "    AwardRecord has:\n" +
    "        TabText is: Award\n" +
    "        DataSourceID is: AwardSource\n" +
    "        // NestedContainer has:\n" +

    "        End: AwardRecord\n" +
    "    Recipients has:\n" +
    "        TabText is: Recipients\n" +
    "        DataSourceID is: AwardStageSource\n" +
    "        // NestedContainer has:\n" +

    "        End: Recipients\n" +
    "    Stages has:\n" +
    "        TabText is: Stages\n" +
    "        DataSourceID is: AwardRecipientSource\n" +
    "        // NestedContainer has:\n" +

    "        End: Stages\n" +
    "    End: Tabs\n";
    
    Param param = ParamConverter.toParam(text);
    //System.out.println(param);
    
    Param tabsParam = param.getParam("Tabs");
    //System.out.println(tabsParam);
    
    return param;
}
//--- Std
private static void print(String text) {
    System.out.println("TabPanelTest" + text);
}

} // End class
