package org.jcon.df.edit.module;

import org.jcon.df.edit.ComponentConfig;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditListener;
import org.jcon.df.work.RowSetEvent;
import org.jcon.param.Param;
import org.jcon.ui.VisualLib;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import org.jcon.util.DataLib;
import java.awt.Component;
import java.awt.Insets;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

/**
 * Provides a tabbed panel.
 *
 * @author Jack Harich
 */
public class TabPanel implements Module {

//---------- Private Fields ------------------------------
private EditListener     controller;
private Vector           childModules = new Vector();
private Vector           controls = new Vector();
private JTabbedPane      tabPane = new JTabbedPane();
private String           name;
private int				 currentPanel = 0;

//---------- Initialization ------------------------------
public TabPanel() {
    // Causes extra components to be drawn back of tabs
    // *** tabPane.setDoubleBuffered(true);

	class TabSelectListener implements ChangeListener {
		public void stateChanged(ChangeEvent e) {
				// This event is caught each time a
				// tab is clicked

				// CMC - Needed to cause tabs to draw when clicked
				tabPane.invalidate();
				tabPane.validate();
			}
	};

	tabPane.addChangeListener(new TabSelectListener());
}
//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {
    // Option - Outer insets
    String outerInsets = param.getString("BorderOuterInsets");
    if (outerInsets != null) {
        Insets insets = VisualLib.parseInsets(outerInsets);
        // OK print(".setParam() - Insets: " + insets);
        EmptyBorder border = new EmptyBorder(insets);
        // *** Swing bug - sized and painted wrong
        // Fixed in Java 1.2 Beta 4 
        // tabPane.setBorder(border);
    }    
    // Prep
    childModules.removeAllElements();
    controls.removeAllElements();
    // Add tabs
    Param tabsParam = param.getParam("Tabs");
    String[] tabKeys = tabsParam.getDataKeys();
    for (int i = 0; i < tabKeys.length; i++) {
        Param tabParam = tabsParam.getParam(tabKeys[i]);
        addTab(tabParam);

		// CMC - This corrects a swing bug where each
		// panel must be selected before it will be
		// properly displayed
		tabPane.setSelectedIndex(currentPanel);
		currentPanel++;
    }
	// CMC - re-select the first tab
	tabPane.setSelectedIndex(0);
}
public Component getComponent() {
    return (Component)tabPane;
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    // Do nothing, not used
}
public String getDataSourceID() {
    return null;
}
public Vector getChildModules() {
    return childModules;
}
public Vector getControls() {
    return controls; // Probably empty
}
public void processRowSetEvent(RowSetEvent evt) {
    // Ignore all
}
public void requestFocus() {
    // Do nothing, may do something later
}
//---------- Private Methods -----------------------------
// Adds nestedComponents to panel on tab
private void addTab(Param param) {
    String tabText = param.getString("TabText");
    //print(".addTab() - Adding " + tabText);

    EasyLayout layout = EasyLayoutRegistry.createLayout(DataView.STYLE_LIBRARY);
    JPanel panel = new JPanel();
    layout.setTopContainer(panel);

    ComponentConfig config = new ComponentConfig(layout,
        param.getParam("NestedContainer"), controller);
    config.setDataSourceID(param.getString("DataSourceID"));
    config.config();
    DataLib.appendVector(controls, config.getControls());

    // Add config's modules to childModules
    Vector configModules = config.getModules();
    for (int i = 0; i < configModules.size(); i++) {
        Module module = (Module)configModules.elementAt(i);
        //print(".addTab() - module dataSourceID = " + module.getDataSourceID());
        childModules.addElement(module);
    }
    // And at last
    tabPane.addTab(tabText, panel);
}
//--- Std
private static void print(String text) {
    System.out.println("TabPanel" + text);
}

} // End class
