package org.jcon.df.edit.module;

import org.jcon.df.edit.ComponentConfig;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditListener;
import org.jcon.df.edit.widget.Widget;
import org.jcon.df.work.RowSetEvent;
import org.jcon.param.Param;
import org.jcon.ui.VisualLib;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import org.jcon.ui.layout.StackedBorderLayout;
import org.jcon.ui.layout.StackedBorderLayoutConstraint;
import org.jcon.util.DataLib;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

/**
* This class is a Module that uses a StackedBorderLayout
* for handling many stacked components on a single panel.
* See StackedBorderLayout for details.
* <p>
* Please note that to control the layout of the panel,
* you MUST add a single top level Module to the parex.
* Param widget names need only be unique per panel, not
* per sheet.
*
* @author Jack Harich
*/         
public class StackedBorderLayoutPanel implements Module {

//---------- Private Fields ------------------------------
// Properties
private String           name;

// Internal
private EditListener     controller;
private Vector           childModules = new Vector();
private Vector           controls = new Vector();
private JPanel           mainPanel = new JPanel();
private BorderPanel      borderPanel = new BorderPanel();

private StackedBorderLayout stackedBorderLayout
    = new StackedBorderLayout();

//---------- Initialization ------------------------------
public StackedBorderLayoutPanel() {
    mainPanel.setLayout(stackedBorderLayout);
}
//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {   

    borderPanel.initMainPanel(param);
    borderPanel.setCenterComponent(mainPanel);
    
    childModules.removeAllElements();
    controls.removeAllElements();
}
public Component getComponent() {
    return borderPanel.getComponent();    
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    // Do nothing, not used
}
public String getDataSourceID() {
    return null;
}
public Vector getChildModules() {
    return childModules;
}
public Vector getControls() {
    return controls; // Probably empty
}
public void processRowSetEvent(RowSetEvent evt) {
    // Ignore all
}
public void requestFocus() {
    // Not supported, could do a default
}
//---------- Properties ----------------------------------

//---------- Public Methods ------------------------------
public void showComponents(Vector names) {
    stackedBorderLayout.showComponents(names);
}
/**
* Adds the NestedContainer components in the param to
* this panel, using the name and position for later use
* in <code>showComponents(Vector names)</code>.
* Returns the top widget.
*/
public Widget addComponent(String name, String position, 
                                            Param param) {
    print(".addCard() - Adding " + name);

    EasyLayout layout = EasyLayoutRegistry.createLayout(DataView.STYLE_LIBRARY);
    JPanel panel = new JPanel();
    layout.setTopContainer(panel); 
    //panel.setBackground(Color.red); // ******** TEST

    ComponentConfig config = new ComponentConfig(layout,
        param.getParam("NestedContainer"), controller);

    config.setDataSourceID(param.getString("DataSourceID"));
    config.config();
    
    // Add config's widgets to mine
    DataLib.appendVector(controls, config.getControls());
    DataLib.appendVector(childModules, config.getModules());

    // Add panel to mainPanel using constraint
    StackedBorderLayoutConstraint constraint = new StackedBorderLayoutConstraint();
    constraint.setName(name);
    constraint.setPosition(position);    
    mainPanel.add(panel, constraint);
    
    return config.getTopWidget();
}
/**
* Returns the named "sub top" Widget or throws an IllegalArgumentException
* if not found. A sub top widget is in the top container
* but is not the top container.
* Modules are checked first and then controls, which should
* not matter since widget names must be unique.
*/
/* public Widget getSubTopWidget(String widgetName) {
    // Check childModules
    for (int i = 0; i < childModules.size(); i++) {
        Widget widget = (Widget)childModules.elementAt(i);
        if (widget.getName().equals(widgetName) return widget;
    }
    // Check controls
    for (int i = 0; i < controls.size(); i++) {
        Widget widget = (Widget)controls.elementAt(i);
        if (widget.getName().equals(widgetName) return widget;
    }
    // Not found
    throw new IllegalArgumentException("The widgetName '" +
        widgetName + "' is not found.");
} */
/**
* Removes the named top Widget and returns it. Returns null
* if not found. This removes it from both internal lists and
* the actual Container.
*/
/* public Widget removeSubTopWidget(String widgetName) {
    // Check childModules
    for (int i = 0; i < childModules.size(); i++) {
        Widget widget = (Widget)childModules.elementAt(i);
        if (widget.getName().equals(widgetName) {
            // *****
            removeMyWidget(widget;
        }
    }
    // Check controls
    for (int i = 0; i < controls.size(); i++) {
        Widget widget = (Widget)controls.elementAt(i);
        if (widget.getName().equals(widgetName) {
            // ********
        }
    }
    // Not found, which is okay
    return null;
} */
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("StackedBorderLayoutPanel" + text);
}

} // End class
