package org.jcon.df.edit.module;

import org.jcon.df.edit.ComponentConfig;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditListener;
import org.jcon.df.edit.control.ControlGroup;
import org.jcon.df.work.RowSetEvent;
import org.jcon.df.work.Row; // test
import org.jcon.param.Param;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;

/**
 * Provides fields (components) on a panel for viewing and
 * editing. Supports nested Modules and Controls, such as
 * the BorderPanel module. This class currently manages ALL
 * bound components (Controls) and is a real workhorse.
 * <p>
 * Note this module supports Border properties, just like
 * BorderPanel.
 * <p>
 * *** We need to redesign Module and Controls to be children
 * of Worker in a Composite pattern. This would allow a
 * cleaner and more extensible system. loadAllControls()
 * and getControls() is a temporary hack.
 *
 * @author Jack Harich
 */
public class RowFieldPanel implements Module {

//---------- Private Fields ------------------------------
private String           dataSourceID;
private BorderPanel      borderPanel = new BorderPanel();
private EditListener     controller;
private Vector           childModules = new Vector();
private Vector           myControls = new Vector();
private ControlGroup     controlGroup = new ControlGroup();
private String           name;

//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {
    borderPanel.initMainPanel(param);

    dataSourceID = param.getString("DataSourceID");

    // Add workers
    EasyLayout layout = EasyLayoutRegistry.createLayout(
        DataView.STYLE_LIBRARY);
    layout.setTopContainer((Container)getComponent());

    ComponentConfig config = new ComponentConfig(layout,
        param.getParam("NestedContainer"), controller);
    config.setDataSourceID(dataSourceID);
    config.config();
    childModules = config.getModules();
    myControls = config.getControls();
    // Init controlGroup
    controlGroup.setControls(loadAllControls());
}
public Component getComponent() {
    return borderPanel.getComponent();
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    this.dataSourceID = dataSourceID;
}
public String getDataSourceID() {
    return dataSourceID;
}
public Vector getChildModules() {
    return childModules;
}
public Vector getControls() {
    return myControls;
}
public void processRowSetEvent(RowSetEvent evt) {
    //print(".processEditEvent() - " + evt);

    switch(evt.getEventType()) {
        case RowSetEvent.CLEAR_ROW:
            controlGroup.emptyRow();
            break;
        case RowSetEvent.CURRENT_ROW_DATA_CHANGED:
            Row row = evt.getCurrentRow();
            //print(" setting row to " + row);
            //print(".processEditEvent() - before setRow");
                controlGroup.setRow(row);
            //print(".processEditEvent() - after setRow");
            break;
        case RowSetEvent.ACQUIRE_EDIT_ROW:
            // was setEditRow, changed 10/16/98 JH
            evt.addRowProperties(controlGroup.getRow());
            break;
        case RowSetEvent.EDIT_STATE_CHANGED:
            boolean editable = (evt.getEditState()
                .equals("View") ? false : true);
            controlGroup.setEditable(editable);

            if (! evt.getEditState().equals("View")) {
                controlGroup.requestFocus();
            }
            break;
        case RowSetEvent.REQUEST_FOCUS:
            controlGroup.requestFocus(evt.getFocusColumnID());
            break;
    }
}
public void requestFocus() {
    // Do nothing, may do something later
}
//---------- Private Methods -----------------------------
// Loads all controls in this class and children, which is
// all controls this class is managing
private Vector loadAllControls() {
    Vector allControls = (Vector)myControls.clone();
    for (int i = 0; i < childModules.size(); i++) {
        Module module = (Module)childModules.elementAt(i);
        loadControls(allControls, module);
        //Vector moreControls = module.getControls();
    }
    return allControls;
}
// RECURSIVE
private void loadControls(Vector allControls, Module module) {
    // Add controls in module
    Vector controls = module.getControls();
    for (int i = 0; i < controls.size(); i++) {
        allControls.addElement(controls.elementAt(i));
    }
    // Add child modules
    Vector modules = module.getChildModules();
    for (int i = 0; i < modules.size(); i++) {
        Module childModule = (Module)modules.elementAt(i);
        loadControls(allControls, childModule);
    }
}
//--- Std
private static void print(String text) {
    System.out.println("RowFieldPanel" + text);
}

} // End class
