package org.jcon.df.edit.module;

import org.jcon.df.edit.EditEvent;
import org.jcon.df.edit.EditListener;
import org.jcon.df.work.RowSetEvent;
import org.jcon.param.Param;
import org.jcon.ui.VisualLib;
import org.jcon.ui.easylayout.EasyLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;

/**
 * Provides a row of buttons for row navigation. These are
 * First, Previous, Next and Last. Also provides display
 * of row position, ie "45 of 5000".
 *
 * @author Jack Harich
 */
public class MoveButtonBar implements Module,
    ActionListener {

//---------- Private Fields ------------------------------
private String           dataSourceID;
private Panel            buttonBar = new Panel();
private EditListener      controller;
private TextField        positionField = new TextField(11);
private Vector           childModules = new Vector();
private Vector           controls = new Vector();
private boolean          movable = true;
private String           name;

private JButton firstBtn = createButton("|<", "First", "Move to first record");
private JButton previousBtn = createButton("<<", "Previous", "Move to previous record");
private JButton nextBtn = createButton(">>", "Next", "Move to next record");
private JButton lastBtn = createButton(">|", "Last", "Move to last record");

// Valid states are Immovable, Beginning, Middle, End
private String           state = "Immovable";

//---------- Initialization ------------------------------
public MoveButtonBar() {

    buttonBar.setLayout(new FlowLayout(
        FlowLayout.CENTER, 0, 0));
    // These will use images later ***
    buttonBar.add(firstBtn);
    buttonBar.add(previousBtn);
    buttonBar.add(nextBtn);
    buttonBar.add(lastBtn);

    // Note - Background is white if only disabled and lightGray
    positionField.setEnabled(false);
    //positionField.setEditable(false);
    positionField.setBackground(Color.cyan);
    buttonBar.add(positionField);

    setState("Immovable"); // Normally Immovable ***
    setPosition(0, 0); // empty
}
//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {
    dataSourceID = param.getString("DataSourceID");
}
public Component getComponent() {
    return buttonBar;
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    this.dataSourceID = dataSourceID;
}
public String getDataSourceID() {
    return dataSourceID;
}
public Vector getChildModules() {
    return childModules; // Empty
}
public Vector getControls() {
    return controls; // Empty
}
public void processRowSetEvent(RowSetEvent evt) {
    //print(".processEditEvent() - " + evt);

    switch(evt.getEventType()) {
        case RowSetEvent.CURRENT_ROW_INDEX_CHANGED:
            setPosition(evt.getCurrentIndex(), evt.getRowCount());
            break;
        case RowSetEvent.MOVE_STATE_CHANGED:
            setState(evt.getMoveState());
            break;
        case RowSetEvent.EDIT_STATE_CHANGED:
            movable = (evt.getEditState()
                .equals("View") ? true : false);
            setState(state);
            break;
    }
}
public void requestFocus() {
    // Do nothing, may do something later
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    //print(".actionPerformed() - " + command);

    if (controller != null) {
        EditEvent editEvent = new EditEvent(
            EditEvent.MOVE_TO, dataSourceID);
        editEvent.setPosition(command);
        controller.processEditEvent(editEvent);
    }
}
//---------- Private Methods -----------------------------
private void setState(String newState) {
    //print(".setState() - " + newState);

    if (newState.equals("Immovable") || ! movable) {
        enableButtons(false, false, false, false);

    } else if (newState.equals("Beginning")) {
        enableButtons(false, false, true, true);

    } else if (newState.equals("Middle")) {
        enableButtons(true, true, true, true);

    } else if (newState.equals("End")) {
        enableButtons(true, true, false, false);

    } else {
        print(".setState() - Unknown state '" + newState + "'");
        return;
    }
    state = newState;
}
private void setPosition(int currentIndex, int rowCount) {
    String text = "No records";
    if (rowCount > 0) {
        text = (currentIndex + 1) + " of " + rowCount;
    }
    positionField.setText(text);
}
private void enableButtons(boolean first,
        boolean previous, boolean next, boolean last) {
    firstBtn.setEnabled(first);
    previousBtn.setEnabled(previous);
    nextBtn.setEnabled(next);
    lastBtn.setEnabled(last);
}
private JButton createButton(String text, String command,
        String toolTip) {
    JButton button = VisualLib.createCompactButton(
        text, command, toolTip);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//--- Std
private static void print(String text) {
    System.out.println("MoveButtonBar" + text);
}

} // End class
