package org.jcon.df.edit.module;

import org.jcon.df.edit.EditListener;
import org.jcon.df.edit.widget.Widget;
import org.jcon.df.work.RowSetListener;
import org.jcon.param.Param;
import org.jcon.ui.easylayout.EasyLayout;
import java.awt.Component;
import java.util.Vector;

/**
 * The interface for "Modules", which are collections of
 * components. They often contain Controls.
 *
 * @author Jack Harich
 */
public interface Module extends Widget, RowSetListener {

// See Widget, RowSetListener

//---------- Other ---------------------------------------
/**
 * Sets the DataSourceID property, which identifies what
 * DataSource this module is bound to.
 */
public void setDataSourceID(String dataSourceID);

/**
 * Returns the DataSourceID.
 */
public String getDataSourceID();

/**
 * Returns the Modules this module has, which is
 * often none.
 */
public Vector getChildModules();

/**
 * Returns the controls this module has, which is often
 * none.
 */
public Vector getControls();

} // End interface
