package org.jcon.df.edit.module;

import org.jcon.df.edit.ComponentConfig;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditListener;
import org.jcon.df.edit.widget.Widget;
import org.jcon.df.work.RowSetEvent;
import org.jcon.param.Param;
import org.jcon.ui.VisualLib;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import org.jcon.util.DataLib;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;

/**
 * Provides a basic card panel with border options.
 * Please note that to control the layout of the panel,
 * you MUST add a single top level Module to the parex.
 * Param widget names need only be unique per card, not
 * per sheet.
 *
 * @author Jack Harich
 */         // Derived from TabPanel
public class CardPanel implements Module {

//---------- Private Fields ------------------------------
// Properties
private String           name;

// Internal
private EditListener     controller;
private Vector           childModules = new Vector();
private Vector           controls = new Vector();
private JPanel           cardPane = new JPanel();
private BorderPanel      borderPanel = new BorderPanel();
private CardLayout       cardLayout = new CardLayout();
private String           currentCardName;

// Key = cardKey, Object = Widget
private Hashtable        widgets = new Hashtable();

//---------- Initialization ------------------------------
public CardPanel() {
    cardPane.setLayout(cardLayout);
}
//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {   

    // Prep
    borderPanel.initMainPanel(param);
    borderPanel.setCenterComponent(cardPane);
    
    childModules.removeAllElements();
    controls.removeAllElements();
    widgets.clear();
    
    // Get cardsParam
    Param cardsParam = param.getParam("Cards");
    if (cardsParam == null) throw new IllegalArgumentException(
        "The Param is missing a 'Cards' entry.");

    // Add cards. Okay if there are none.
    // There are usually none, and are added by addCard().
    String[] cardKeys = cardsParam.getDataKeys();
    for (int i = 0; i < cardKeys.length; i++) {
        String cardKey = cardKeys[i];
        Param cardParam = cardsParam.getParam(cardKey);
        addCard(cardKey, cardParam);
        if (i == 0) currentCardName = cardKey;
    }
}
public Component getComponent() {
    return borderPanel.getComponent();    
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    // Do nothing, not used
}
public String getDataSourceID() {
    return null;
}
public Vector getChildModules() {
    return childModules;
}
public Vector getControls() {
    return controls; // Probably empty
}
public void processRowSetEvent(RowSetEvent evt) {
    // Ignore all
}
public void requestFocus() {
    // Forward to current card's widget
    Widget widget = (Widget)widgets.get(currentCardName);
    //print(".requestFocus() - calling on widget = " + widget);
    widget.requestFocus();
}
//---------- Properties ----------------------------------
public String getCurrentCardName() {
    return currentCardName;
}
//---------- Public Methods ------------------------------
public void showCard(String cardKey) {
    cardLayout.show(cardPane, cardKey);
    currentCardName = cardKey;
}
// Adds nestedComponents to panel on card
public void addCard(String cardKey, Param param) {
    print(".addCard() - Adding " + cardKey);

    EasyLayout layout = EasyLayoutRegistry.createLayout(DataView.STYLE_LIBRARY);
    JPanel panel = new JPanel();
    layout.setTopContainer(panel); 
    //panel.setBackground(Color.red); // *** TEST

    ComponentConfig config = new ComponentConfig(layout,
        param.getParam("NestedContainer"), controller);

    config.setDataSourceID(param.getString("DataSourceID"));
    config.config();
    widgets.put(cardKey, config.getTopWidget());
    
    // Add config's widgets to mine
    DataLib.appendVector(controls, config.getControls());
    DataLib.appendVector(childModules, config.getModules());

    // And at last
    cardPane.add(cardKey, panel);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CardPanel" + text);
}

} // End class
