package org.jcon.df.edit.module;

import org.jcon.df.edit.ComponentConfig;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.EditListener;
import org.jcon.df.work.RowSetEvent;
import org.jcon.param.Param;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import org.jcon.ui.VisualLib;
import org.jcon.util.GenLib;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
//import java.awt.Panel;
import java.awt.TextField; // *** test
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.border.*;

/**
 * Provides a bordered panel. (Derived from RowFieldPanel)
 * *** Add defaults here ***
 *
 * @author Jack Harich
 */
public class BorderPanel implements Module {

//---------- Private Fields ------------------------------
private EditListener     controller;
private Vector           childModules = new Vector();
private Vector           controls     = new Vector();
private JPanel           mainPanel    = new JPanel();
private String           name;
private Border           mainBorder;

//---------- Initialization ------------------------------
// public to allow RowFieldPanel, ListControl and others to use me
public void initMainPanel(Param param) {
    // Param properties - All null if none
    String title  = param.getString("BorderTitle");
    String type   = param.getString("BorderStyle");
    // Insets are - top, left, bottom, right
    String outerInsets = param.getString("BorderOuterInsets");
    String innerInsets = param.getString("BorderInnerInsets");
    // Default is not bold
    boolean titleBold = param.isTrueDefaultFalse("BorderTitleBold");
    // Preferred Size
    String line = param.getString("BorderSize");
    if (line != null) {
        mainPanel.setPreferredSize(VisualLib.parseDimension(line));
    }
    // Set type default
    if (title == null) {            
        if (type == null) type = "Blank";
    } else {
        // Title not null
        if (type == null) type = "Etched";
    }
    //
    // Prepare mainBorder
    if (type == "LoweredBevel") {
        mainBorder = new BevelBorder(BevelBorder.LOWERED);

    } else if (type == "RaisedBevel") {
        mainBorder = new BevelBorder(BevelBorder.RAISED);

    } else if (type == "Etched") { // Lowered is default
        mainBorder = new EtchedBorder();

    } else if (type == "Blank") {
        mainBorder = new EmptyBorder(0, 0, 0, 0);

    } else {
        GenLib.error("BorderPanel.initMainPanel()",
            "Unknown border type '" + type + "', using Etched.");
        mainBorder = new EtchedBorder();
    }
    // Option - Title 
    if (title != null) {
        TitledBorder border = new TitledBorder(mainBorder, title);
        // Make the title bold - Looks awkward
        Font font = border.getTitleFont();
        if (titleBold) font = VisualLib.makeFontBold(font);
        border.setTitleFont(font);
        mainBorder = (Border)border;
    }
    // (outsideBorder, insideBorder)
    // Option - Inner insets, must be before Outer insets
    if (innerInsets != null) {
        Insets insets = VisualLib.parseInsets(innerInsets);
        EmptyBorder innerBorder = new EmptyBorder(insets);
        mainBorder = new CompoundBorder(mainBorder, innerBorder);
    }
    // Option - Outer insets
    if (outerInsets != null) {
        Insets insets = VisualLib.parseInsets(outerInsets);
        EmptyBorder outerBorder = new EmptyBorder(insets);
        mainBorder = new CompoundBorder(outerBorder, mainBorder);
    }
    // Done
    mainPanel.setDoubleBuffered(true);
    mainPanel.setBorder(mainBorder);
}
//---------- Module Implementation -----------------------
//----- Name
public void setName(String name) {
    this.name = name;
}
public String getName() {
    return name;
}
//----- Other
public void setParam(Param param) {
    initMainPanel(param);

    // Add workers - Similar code to RowFieldPanel
    EasyLayout layout = EasyLayoutRegistry.createLayout(
        DataView.STYLE_LIBRARY);
    layout.setTopContainer(mainPanel);

    ComponentConfig config = new ComponentConfig(layout,
        param.getParam("NestedContainer"), controller);
    config.setDataSourceID(param.getString("DataSourceID"));
    config.config();
    childModules = config.getModules();
    controls = config.getControls();
}
public Component getComponent() {
    return (Component)mainPanel;
}
public void setEditListener(EditListener controller) {
    this.controller = controller;
}
public void setDataSourceID(String dataSourceID) {
    // Do nothing, not used
}
public String getDataSourceID() {
    return null;
}
public Vector getChildModules() {
    return childModules;
}
public Vector getControls() {
    return controls;
}
public void processRowSetEvent(RowSetEvent evt) {
    // Ignore all
}
public void requestFocus() {
    // Do nothing
}
//---------- Properties ----------------------------------
public Border getBorder() {
    return mainBorder;
}
/**
* For BorderPanels with no defined components. This allows
* custom use of this class.
*/
public void setCenterComponent(Component comp) {
    mainPanel.setLayout(new BorderLayout());
    mainPanel.add("Center", comp);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("BorderPanel" + text);
}

} // End class
